/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.internal;

import com.aptana.portal.ui.internal.BrowserFunctionWrapper;
import com.aptana.portal.ui.internal.IBrowserFunctionHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowserWrapper {
    private final Object browser;

    public BrowserWrapper(Object browser) {
        this.browser = browser;
    }

    public BrowserFunctionWrapper createBrowserFunction(String name, final IBrowserFunctionHandler handler) {
        return new BrowserFunctionWrapper(new BrowserFunction((Browser)this.browser, name){

            public Object function(Object[] arguments) {
                return handler.function(arguments);
            }
        });
    }

    private Object callMethod(String name, Class<?>[] parameterTypes, Object[] arguments) {
        try {
            Method method = this.browser.getClass().getMethod(name, parameterTypes);
            return method.invoke(this.browser, arguments);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object callMethod(String name, Class<?> parameterType, Object argument) {
        return this.callMethod(name, new Class[]{parameterType}, new Object[]{argument});
    }

    private Object callMethod(String name) {
        return this.callMethod(name, new Class[0], new Object[0]);
    }

    public void addTitleListener(TitleListener listener) {
        this.callMethod("addTitleListener", TitleListener.class, listener);
    }

    public void addProgressListener(ProgressListener listener) {
        this.callMethod("addProgressListener", ProgressListener.class, listener);
    }

    public void addLocationListener(LocationListener listener) {
        this.callMethod("addLocationListener", LocationListener.class, listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.callMethod("addDisposeListener", DisposeListener.class, listener);
    }

    public boolean isDisposed() {
        return (Boolean)this.callMethod("isDisposed");
    }

    public boolean execute(String script) {
        return (Boolean)this.callMethod("execute", String.class, script);
    }

    public void setJavascriptEnabled(boolean enabled) {
        this.callMethod("setJavascriptEnabled", Boolean.TYPE, enabled);
    }

    public String getUrl() {
        return (String)this.callMethod("getUrl");
    }

    public boolean setUrl(String url) {
        return (Boolean)this.callMethod("setUrl", String.class, url);
    }

    public boolean setFocus() {
        return (Boolean)this.callMethod("setFocus");
    }
}

